/*
 * Decompiled with CFR 0.152.
 */
package sv.mh.fe.models.minec;

import java.util.List;
import sv.mh.fe.models.minec.AccessDescription;
import sv.mh.fe.models.minec.AuthorityInfoAccess;
import sv.mh.fe.models.minec.AuthorityKeyIdentifier;
import sv.mh.fe.models.minec.BasicConstraints;
import sv.mh.fe.models.minec.CertificatePolicies;
import sv.mh.fe.models.minec.CrlDistributionPoint;
import sv.mh.fe.models.minec.ExtendedKeyUsage;
import sv.mh.fe.models.minec.KeyUsage;
import sv.mh.fe.models.minec.QcPDS;
import sv.mh.fe.models.minec.QualifiedCertificateStatements;
import sv.mh.fe.models.minec.SubjectAlternativeNames;
import sv.mh.fe.models.minec.SubjectKeyIdentifier;

public class Extensions {
    private AuthorityKeyIdentifier authorityKeyIdentifier;
    private SubjectKeyIdentifier subjectKeyIdentifier;
    private KeyUsage keyUsage;
    private CertificatePolicies certificatePolicies;
    private SubjectAlternativeNames subjectAlternativeNames;
    private ExtendedKeyUsage extendedKeyUsage;
    private CrlDistributionPoint crlDistributionPoint;
    private AuthorityInfoAccess authorityInfoAccess;
    private QualifiedCertificateStatements qualifiedCertificateStatements;
    private BasicConstraints basicConstraints;

    public Extensions(String rfc822Name, List<String> crlDistributionPoint, List<String> accessLocation) {
        this.authorityKeyIdentifier = new AuthorityKeyIdentifier();
        this.subjectKeyIdentifier = new SubjectKeyIdentifier();
        this.keyUsage = new KeyUsage();
        this.certificatePolicies = new CertificatePolicies();
        this.subjectAlternativeNames = new SubjectAlternativeNames(rfc822Name);
        this.extendedKeyUsage = new ExtendedKeyUsage();
        this.crlDistributionPoint = new CrlDistributionPoint(crlDistributionPoint);
        this.authorityInfoAccess = new AuthorityInfoAccess();
        this.authorityInfoAccess.addAccessDescription(new AccessDescription(accessLocation));
        this.qualifiedCertificateStatements = new QualifiedCertificateStatements(new QcPDS());
        this.basicConstraints = new BasicConstraints();
    }

    public Extensions() {
    }

    public Extensions(AuthorityKeyIdentifier authorityKeyIdentifier, SubjectKeyIdentifier subjectKeyIdentifier, KeyUsage keyUsage, CertificatePolicies certificatePolicies, SubjectAlternativeNames subjectAlternativeNames, ExtendedKeyUsage extendedKeyUsage, CrlDistributionPoint crlDistributionPoint, AuthorityInfoAccess authorityInfoAccess, QualifiedCertificateStatements qualifiedCertificateStatements, BasicConstraints basicConstraints) {
        this.authorityKeyIdentifier = authorityKeyIdentifier;
        this.subjectKeyIdentifier = subjectKeyIdentifier;
        this.keyUsage = keyUsage;
        this.certificatePolicies = certificatePolicies;
        this.subjectAlternativeNames = subjectAlternativeNames;
        this.extendedKeyUsage = extendedKeyUsage;
        this.crlDistributionPoint = crlDistributionPoint;
        this.authorityInfoAccess = authorityInfoAccess;
        this.qualifiedCertificateStatements = qualifiedCertificateStatements;
        this.basicConstraints = basicConstraints;
    }

    public AuthorityKeyIdentifier getAuthorityKeyIdentifier() {
        return this.authorityKeyIdentifier;
    }

    public void setAuthorityKeyIdentifier(AuthorityKeyIdentifier authorityKeyIdentifier) {
        this.authorityKeyIdentifier = authorityKeyIdentifier;
    }

    public SubjectKeyIdentifier getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier;
    }

    public void setSubjectKeyIdentifier(SubjectKeyIdentifier subjectKeyIdentifier) {
        this.subjectKeyIdentifier = subjectKeyIdentifier;
    }

    public KeyUsage getKeyUsage() {
        return this.keyUsage;
    }

    public void setKeyUsage(KeyUsage keyUsage) {
        this.keyUsage = keyUsage;
    }

    public CertificatePolicies getCertificatePolicies() {
        return this.certificatePolicies;
    }

    public void setCertificatePolicies(CertificatePolicies certificatePolicies) {
        this.certificatePolicies = certificatePolicies;
    }

    public SubjectAlternativeNames getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public void setSubjectAlternativeNames(SubjectAlternativeNames subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
    }

    public ExtendedKeyUsage getExtendedKeyUsage() {
        return this.extendedKeyUsage;
    }

    public void setExtendedKeyUsage(ExtendedKeyUsage extendedKeyUsage) {
        this.extendedKeyUsage = extendedKeyUsage;
    }

    public CrlDistributionPoint getCrlDistributionPoint() {
        return this.crlDistributionPoint;
    }

    public void setCrlDistributionPoint(CrlDistributionPoint crlDistributionPoint) {
        this.crlDistributionPoint = crlDistributionPoint;
    }

    public AuthorityInfoAccess getAuthorityInfoAccess() {
        return this.authorityInfoAccess;
    }

    public void setAuthorityInfoAccess(AuthorityInfoAccess authorityInfoAccess) {
        this.authorityInfoAccess = authorityInfoAccess;
    }

    public QualifiedCertificateStatements getQualifiedCertificateStatements() {
        return this.qualifiedCertificateStatements;
    }

    public void setQualifiedCertificateStatements(QualifiedCertificateStatements qualifiedCertificateStatements) {
        this.qualifiedCertificateStatements = qualifiedCertificateStatements;
    }

    public BasicConstraints getBasicConstraints() {
        return this.basicConstraints;
    }

    public void setBasicConstraints(BasicConstraints basicConstraints) {
        this.basicConstraints = basicConstraints;
    }
}

